# Cuadro IV.1
# Intervalo de confianza de la media de una poblacin normal
########################################################
# Seccin modificable por el usuario
########################################################
# Lectura de la base de datos
datos<-read.csv2("Cuadro IV.1.V.csv",encoding="latin1")

# Seleccin de las variables de inters
#varInteres<-c("Altura.cm")
varInteres<-c("Altura.cm","Peso.Kg")

# Seleccin de categorizacin de las variables
# Si no se utilizan variables de agrupacin obligatoriamente
# se exige que se coloce varAgrupacin como NULL
#varAgrupacion<-NULL
varAgrupacion<-c("Sexo")
#varAgrupacion<-c("Pas","Ciudad","Sexo")

# Indique el nivel de significancia
alfa<-0.05

# Nombre del archivo de salida
ArchivodeSalida<-"Salida Cuadro IV.1.V.csv"

# Los datos comprenden toda la poblacin?
total<-"no"

########################################################
# Seccin que realiza el procedimiento
########################################################

valores<-unlist(datos[,varInteres])
variables<-factor(rep(varInteres,each=dim(datos)[1]))
agrupaciones<-data.frame(datos[rep(1:dim(datos)[1],length(varInteres)),varAgrupacion])
names(agrupaciones)<-varAgrupacion

datos2<-data.frame(agrupaciones,variable=variables,valor=valores)

varAgrupacion<-c(varAgrupacion,"variable")

# Funcin que devuelve slo el intervalo de confianza
# De acuerdo a las especifiaciones dadas.
IC<-function(x,sup=TRUE,alfa=0.05,total="SI"){
   if (length(x[!is.na(x)])>=2){
    if (toupper(total)=="SI"){
       x<-x[!is.na(x)]
       n<-length(x)
       m<-mean(x)
       desv.tipica<-sqrt(sum((x-m)^2)/n)
       zalfa<-qnorm(1-alfa/2)
       v<-ifelse(sup,round(m+zalfa*desv.tipica/sqrt(n),7),round(m-zalfa*desv.tipica/sqrt(n),7))     
    }else{
      if (length(x[!is.na(x)])>=30){
         x<-x[!is.na(x)]
	 n<-length(x)
	 m<-mean(x)
	 desv.tipica<-sd(x)
	 zalfa<-qnorm(1-alfa/2)
	 v<-ifelse(sup,round(m+zalfa*desv.tipica/sqrt(n),7),round(m-zalfa*desv.tipica/sqrt(n),7))     
      }else{
         pruebaT<-t.test(x[!is.na(x)],conf.level=1-alfa)
         v<-ifelse(sup,round(pruebaT$conf.int[2],7),round(pruebaT$conf.int[1],7))
        }
    }
    return(v)
   } else return(NA)
  # else {if(length(x)==0) return(NULL) else return(c(NA,NA)) }
}

agrupa<-data.frame(datos2[,varAgrupacion])
if(length(varAgrupacion)==1) names(agrupa)<-varAgrupacion
media<-as.data.frame.table(tapply(datos2$valor,as.list(agrupa),mean,na.rm=TRUE),responseName="Media")
ICs1<-as.data.frame.table(tapply(datos2$valor,as.list(agrupa),IC,alfa=alfa,total=total),responseName="LimSup")
ICs2<-as.data.frame.table(tapply(datos2$valor,as.list(agrupa),IC,sup=FALSE,alfa=alfa,total=total),responseName="LimInf")

ICs<-na.omit(data.frame(ICs2,Media=media[,"Media"],LimSup=ICs1[,"LimSup"]))

########################################################
# Seccin que muestra los resultados
########################################################

ICs

if (!is.null(ArchivodeSalida)) write.csv2(ICs,ArchivodeSalida,row.names=FALSE)
